<?php

/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/

declare(strict_types=1);

namespace ShopifyTest\Rest;

use Shopify\Auth\Session;
use Shopify\Context;
use Shopify\Rest\Admin2023_04\AbandonedCheckout;
use ShopifyTest\BaseTestCase;
use ShopifyTest\Clients\MockRequest;

final class AbandonedCheckout202304Test extends BaseTestCase
{
    /** @var Session */
    private $test_session;

    public function setUp(): void
    {
        parent::setUp();

        Context::$API_VERSION = "2023-04";

        $this->test_session = new Session("session_id", "test-shop.myshopify.io", true, "1234");
        $this->test_session->setAccessToken("this_is_a_test_token");
    }

    /**

     *
     * @return void
     */
    public function test_1(): void
    {
        $this->mockTransportRequests([
            new MockRequest(
                $this->buildMockHttpResponse(200, json_encode(
                  ["checkouts" => [["id" => 450789469, "token" => "2a1ace52255252df566af0faaedfbfa7", "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "email" => "bob.norman@mail.example.com", "gateway" => null, "buyer_accepts_marketing" => false, "created_at" => "2012-10-12T07:05:27-04:00", "updated_at" => "2012-10-12T07:05:27-04:00", "landing_site" => null, "note" => null, "note_attributes" => [["name" => "custom engraving", "value" => "Happy Birthday"], ["name" => "colour", "value" => "green"]], "referring_site" => null, "shipping_lines" => [["code" => "Free Shipping", "price" => "0.00", "original_shop_price" => null, "original_rate_price" => null, "original_shop_markup" => null, "source" => "shopify", "title" => "Free Shipping", "presentment_title" => null, "phone" => null, "tax_lines" => null, "custom_tax_lines" => null, "validation_context" => null, "markup" => null, "delivery_category" => null, "carrier_identifier" => null, "carrier_service_id" => null, "api_client_id" => null, "requested_fulfillment_service_id" => null, "applied_discounts" => [], "delivery_option_group_type" => null, "delivery_expectation_range" => null, "delivery_expectation_type" => null, "estimated_delivery_time_range" => null, "id" => "5da41c1738454765"]], "taxes_included" => false, "total_weight" => 400, "currency" => "USD", "completed_at" => null, "closed_at" => null, "user_id" => null, "location_id" => null, "source_identifier" => null, "source_url" => null, "device_id" => null, "phone" => null, "customer_locale" => "en", "line_items" => [["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "17243a6e53c8a58c", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Red", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 49148385, "variant_title" => "Red", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"], ["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "4b8183cc74918eca", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Pink", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008PINK", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 808950810, "variant_title" => "Pink", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"]], "name" => "#450789469", "source" => null, "abandoned_checkout_url" => "https://checkout.local/548380009/checkouts/2a1ace52255252df566af0faaedfbfa7/recover", "discount_codes" => [["code" => "TENOFF", "amount" => "39.80", "type" => "percentage"]], "tax_lines" => [["price" => "21.49", "rate" => 0.06, "title" => "State Tax", "channel_liable" => null]], "source_name" => "web", "presentment_currency" => "USD", "buyer_accepts_sms_marketing" => false, "sms_marketing_phone" => null, "total_discounts" => "39.80", "total_line_items_price" => "398.00", "total_price" => "379.69", "total_tax" => "21.49", "subtotal_price" => "358.20", "total_duties" => null, "billing_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "shipping_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "customer" => ["id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-04-04T17:13:27-04:00", "updated_at" => "2023-04-04T17:13:27-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => null, "verified_email" => true, "multipass_identifier" => null, "tax_exempt" => false, "tags" => "L\u00E9on, No\u00EBl", "last_order_name" => "#1001", "currency" => "USD", "phone" => "+16136120707", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => null, "tax_exemptions" => [], "email_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => null, "consent_updated_at" => "2004-06-13T11:57:11-04:00"], "sms_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-04-04T17:13:27-04:00", "consent_collected_from" => "OTHER"], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => ["id" => 207119551, "customer_id" => 207119551, "first_name" => null, "last_name" => null, "company" => null, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true]]]]]
                )),
                "https://test-shop.myshopify.io/admin/api/2023-04/checkouts.json?created_at_max=2013-10-12T07%3A05%3A27-02%3A00",
                "GET",
                null,
                [
                    "X-Shopify-Access-Token: this_is_a_test_token",
                ],
            ),
        ]);

        AbandonedCheckout::checkouts(
            $this->test_session,
            [],
            ["created_at_max" => "2013-10-12T07:05:27-02:00"],
        );
    }

    /**

     *
     * @return void
     */
    public function test_2(): void
    {
        $this->mockTransportRequests([
            new MockRequest(
                $this->buildMockHttpResponse(200, json_encode(
                  ["checkouts" => [["id" => 450789469, "token" => "2a1ace52255252df566af0faaedfbfa7", "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "email" => "bob.norman@mail.example.com", "gateway" => null, "buyer_accepts_marketing" => false, "created_at" => "2012-10-12T07:05:27-04:00", "updated_at" => "2012-10-12T07:05:27-04:00", "landing_site" => null, "note" => null, "note_attributes" => [["name" => "custom engraving", "value" => "Happy Birthday"], ["name" => "colour", "value" => "green"]], "referring_site" => null, "shipping_lines" => [["code" => "Free Shipping", "price" => "0.00", "original_shop_price" => null, "original_rate_price" => null, "original_shop_markup" => null, "source" => "shopify", "title" => "Free Shipping", "presentment_title" => null, "phone" => null, "tax_lines" => null, "custom_tax_lines" => null, "validation_context" => null, "markup" => null, "delivery_category" => null, "carrier_identifier" => null, "carrier_service_id" => null, "api_client_id" => null, "requested_fulfillment_service_id" => null, "applied_discounts" => [], "delivery_option_group_type" => null, "delivery_expectation_range" => null, "delivery_expectation_type" => null, "estimated_delivery_time_range" => null, "id" => "5da41c1738454765"]], "taxes_included" => false, "total_weight" => 400, "currency" => "USD", "completed_at" => null, "closed_at" => null, "user_id" => null, "location_id" => null, "source_identifier" => null, "source_url" => null, "device_id" => null, "phone" => null, "customer_locale" => "en", "line_items" => [["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "17243a6e53c8a58c", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Red", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 49148385, "variant_title" => "Red", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"], ["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "4b8183cc74918eca", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Pink", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008PINK", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 808950810, "variant_title" => "Pink", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"]], "name" => "#450789469", "source" => null, "abandoned_checkout_url" => "https://checkout.local/548380009/checkouts/2a1ace52255252df566af0faaedfbfa7/recover", "discount_codes" => [["code" => "TENOFF", "amount" => "39.80", "type" => "percentage"]], "tax_lines" => [["price" => "21.49", "rate" => 0.06, "title" => "State Tax", "channel_liable" => null]], "source_name" => "web", "presentment_currency" => "USD", "buyer_accepts_sms_marketing" => false, "sms_marketing_phone" => null, "total_discounts" => "39.80", "total_line_items_price" => "398.00", "total_price" => "379.69", "total_tax" => "21.49", "subtotal_price" => "358.20", "total_duties" => null, "billing_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "shipping_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "customer" => ["id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-04-04T17:13:27-04:00", "updated_at" => "2023-04-04T17:13:27-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => null, "verified_email" => true, "multipass_identifier" => null, "tax_exempt" => false, "tags" => "L\u00E9on, No\u00EBl", "last_order_name" => "#1001", "currency" => "USD", "phone" => "+16136120707", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => null, "tax_exemptions" => [], "email_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => null, "consent_updated_at" => "2004-06-13T11:57:11-04:00"], "sms_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-04-04T17:13:27-04:00", "consent_collected_from" => "OTHER"], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => ["id" => 207119551, "customer_id" => 207119551, "first_name" => null, "last_name" => null, "company" => null, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true]]]]]
                )),
                "https://test-shop.myshopify.io/admin/api/2023-04/checkouts.json",
                "GET",
                null,
                [
                    "X-Shopify-Access-Token: this_is_a_test_token",
                ],
            ),
        ]);

        AbandonedCheckout::checkouts(
            $this->test_session,
            [],
            [],
        );
    }

    /**

     *
     * @return void
     */
    public function test_3(): void
    {
        $this->mockTransportRequests([
            new MockRequest(
                $this->buildMockHttpResponse(200, json_encode(
                  ["checkouts" => [["id" => 450789469, "token" => "2a1ace52255252df566af0faaedfbfa7", "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "email" => "bob.norman@mail.example.com", "gateway" => null, "buyer_accepts_marketing" => false, "created_at" => "2012-10-12T07:05:27-04:00", "updated_at" => "2012-10-12T07:05:27-04:00", "landing_site" => null, "note" => null, "note_attributes" => [["name" => "custom engraving", "value" => "Happy Birthday"], ["name" => "colour", "value" => "green"]], "referring_site" => null, "shipping_lines" => [["code" => "Free Shipping", "price" => "0.00", "original_shop_price" => null, "original_rate_price" => null, "original_shop_markup" => null, "source" => "shopify", "title" => "Free Shipping", "presentment_title" => null, "phone" => null, "tax_lines" => null, "custom_tax_lines" => null, "validation_context" => null, "markup" => null, "delivery_category" => null, "carrier_identifier" => null, "carrier_service_id" => null, "api_client_id" => null, "requested_fulfillment_service_id" => null, "applied_discounts" => [], "delivery_option_group_type" => null, "delivery_expectation_range" => null, "delivery_expectation_type" => null, "estimated_delivery_time_range" => null, "id" => "5da41c1738454765"]], "taxes_included" => false, "total_weight" => 400, "currency" => "USD", "completed_at" => null, "closed_at" => null, "user_id" => null, "location_id" => null, "source_identifier" => null, "source_url" => null, "device_id" => null, "phone" => null, "customer_locale" => "en", "line_items" => [["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "17243a6e53c8a58c", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Red", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 49148385, "variant_title" => "Red", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"], ["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "4b8183cc74918eca", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Pink", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008PINK", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 808950810, "variant_title" => "Pink", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"]], "name" => "#450789469", "source" => null, "abandoned_checkout_url" => "https://checkout.local/548380009/checkouts/2a1ace52255252df566af0faaedfbfa7/recover", "discount_codes" => [["code" => "TENOFF", "amount" => "39.80", "type" => "percentage"]], "tax_lines" => [["price" => "21.49", "rate" => 0.06, "title" => "State Tax", "channel_liable" => null]], "source_name" => "web", "presentment_currency" => "USD", "buyer_accepts_sms_marketing" => false, "sms_marketing_phone" => null, "total_discounts" => "39.80", "total_line_items_price" => "398.00", "total_price" => "379.69", "total_tax" => "21.49", "subtotal_price" => "358.20", "total_duties" => null, "billing_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "shipping_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "customer" => ["id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-04-04T17:13:27-04:00", "updated_at" => "2023-04-04T17:13:27-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => null, "verified_email" => true, "multipass_identifier" => null, "tax_exempt" => false, "tags" => "L\u00E9on, No\u00EBl", "last_order_name" => "#1001", "currency" => "USD", "phone" => "+16136120707", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => null, "tax_exemptions" => [], "email_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => null, "consent_updated_at" => "2004-06-13T11:57:11-04:00"], "sms_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-04-04T17:13:27-04:00", "consent_collected_from" => "OTHER"], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => ["id" => 207119551, "customer_id" => 207119551, "first_name" => null, "last_name" => null, "company" => null, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true]]]]]
                )),
                "https://test-shop.myshopify.io/admin/api/2023-04/checkouts.json?status=closed",
                "GET",
                null,
                [
                    "X-Shopify-Access-Token: this_is_a_test_token",
                ],
            ),
        ]);

        AbandonedCheckout::checkouts(
            $this->test_session,
            [],
            ["status" => "closed"],
        );
    }

    /**

     *
     * @return void
     */
    public function test_4(): void
    {
        $this->mockTransportRequests([
            new MockRequest(
                $this->buildMockHttpResponse(200, json_encode(
                  ["checkouts" => [["id" => 450789469, "token" => "2a1ace52255252df566af0faaedfbfa7", "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "email" => "bob.norman@mail.example.com", "gateway" => null, "buyer_accepts_marketing" => false, "created_at" => "2012-10-12T07:05:27-04:00", "updated_at" => "2012-10-12T07:05:27-04:00", "landing_site" => null, "note" => null, "note_attributes" => [["name" => "custom engraving", "value" => "Happy Birthday"], ["name" => "colour", "value" => "green"]], "referring_site" => null, "shipping_lines" => [["code" => "Free Shipping", "price" => "0.00", "original_shop_price" => null, "original_rate_price" => null, "original_shop_markup" => null, "source" => "shopify", "title" => "Free Shipping", "presentment_title" => null, "phone" => null, "tax_lines" => null, "custom_tax_lines" => null, "validation_context" => null, "markup" => null, "delivery_category" => null, "carrier_identifier" => null, "carrier_service_id" => null, "api_client_id" => null, "requested_fulfillment_service_id" => null, "applied_discounts" => [], "delivery_option_group_type" => null, "delivery_expectation_range" => null, "delivery_expectation_type" => null, "estimated_delivery_time_range" => null, "id" => "5da41c1738454765"]], "taxes_included" => false, "total_weight" => 400, "currency" => "USD", "completed_at" => null, "closed_at" => null, "user_id" => null, "location_id" => null, "source_identifier" => null, "source_url" => null, "device_id" => null, "phone" => null, "customer_locale" => "en", "line_items" => [["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "17243a6e53c8a58c", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Red", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 49148385, "variant_title" => "Red", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"], ["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "4b8183cc74918eca", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Pink", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008PINK", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 808950810, "variant_title" => "Pink", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"]], "name" => "#450789469", "source" => null, "abandoned_checkout_url" => "https://checkout.local/548380009/checkouts/2a1ace52255252df566af0faaedfbfa7/recover", "discount_codes" => [["code" => "TENOFF", "amount" => "39.80", "type" => "percentage"]], "tax_lines" => [["price" => "21.49", "rate" => 0.06, "title" => "State Tax", "channel_liable" => null]], "source_name" => "web", "presentment_currency" => "USD", "buyer_accepts_sms_marketing" => false, "sms_marketing_phone" => null, "total_discounts" => "39.80", "total_line_items_price" => "398.00", "total_price" => "379.69", "total_tax" => "21.49", "subtotal_price" => "358.20", "total_duties" => null, "billing_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "shipping_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "customer" => ["id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-04-04T17:13:27-04:00", "updated_at" => "2023-04-04T17:13:27-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => null, "verified_email" => true, "multipass_identifier" => null, "tax_exempt" => false, "tags" => "L\u00E9on, No\u00EBl", "last_order_name" => "#1001", "currency" => "USD", "phone" => "+16136120707", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => null, "tax_exemptions" => [], "email_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => null, "consent_updated_at" => "2004-06-13T11:57:11-04:00"], "sms_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-04-04T17:13:27-04:00", "consent_collected_from" => "OTHER"], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => ["id" => 207119551, "customer_id" => 207119551, "first_name" => null, "last_name" => null, "company" => null, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true]]]]]
                )),
                "https://test-shop.myshopify.io/admin/api/2023-04/checkouts.json?limit=1",
                "GET",
                null,
                [
                    "X-Shopify-Access-Token: this_is_a_test_token",
                ],
            ),
        ]);

        AbandonedCheckout::checkouts(
            $this->test_session,
            [],
            ["limit" => "1"],
        );
    }

    /**

     *
     * @return void
     */
    public function test_5(): void
    {
        $this->mockTransportRequests([
            new MockRequest(
                $this->buildMockHttpResponse(200, json_encode(
                  ["checkouts" => [["id" => 450789469, "token" => "2a1ace52255252df566af0faaedfbfa7", "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "email" => "bob.norman@mail.example.com", "gateway" => null, "buyer_accepts_marketing" => false, "created_at" => "2012-10-12T07:05:27-04:00", "updated_at" => "2012-10-12T07:05:27-04:00", "landing_site" => null, "note" => null, "note_attributes" => [["name" => "custom engraving", "value" => "Happy Birthday"], ["name" => "colour", "value" => "green"]], "referring_site" => null, "shipping_lines" => [["code" => "Free Shipping", "price" => "0.00", "original_shop_price" => null, "original_rate_price" => null, "original_shop_markup" => null, "source" => "shopify", "title" => "Free Shipping", "presentment_title" => null, "phone" => null, "tax_lines" => null, "custom_tax_lines" => null, "validation_context" => null, "markup" => null, "delivery_category" => null, "carrier_identifier" => null, "carrier_service_id" => null, "api_client_id" => null, "requested_fulfillment_service_id" => null, "applied_discounts" => [], "delivery_option_group_type" => null, "delivery_expectation_range" => null, "delivery_expectation_type" => null, "estimated_delivery_time_range" => null, "id" => "5da41c1738454765"]], "taxes_included" => false, "total_weight" => 400, "currency" => "USD", "completed_at" => null, "closed_at" => null, "user_id" => null, "location_id" => null, "source_identifier" => null, "source_url" => null, "device_id" => null, "phone" => null, "customer_locale" => "en", "line_items" => [["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "17243a6e53c8a58c", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Red", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 49148385, "variant_title" => "Red", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"], ["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "4b8183cc74918eca", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Pink", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008PINK", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 808950810, "variant_title" => "Pink", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"]], "name" => "#450789469", "source" => null, "abandoned_checkout_url" => "https://checkout.local/548380009/checkouts/2a1ace52255252df566af0faaedfbfa7/recover", "discount_codes" => [["code" => "TENOFF", "amount" => "39.80", "type" => "percentage"]], "tax_lines" => [["price" => "21.49", "rate" => 0.06, "title" => "State Tax", "channel_liable" => null]], "source_name" => "web", "presentment_currency" => "USD", "buyer_accepts_sms_marketing" => false, "sms_marketing_phone" => null, "total_discounts" => "39.80", "total_line_items_price" => "398.00", "total_price" => "379.69", "total_tax" => "21.49", "subtotal_price" => "358.20", "total_duties" => null, "billing_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "shipping_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "customer" => ["id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-04-04T17:13:27-04:00", "updated_at" => "2023-04-04T17:13:27-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => null, "verified_email" => true, "multipass_identifier" => null, "tax_exempt" => false, "tags" => "L\u00E9on, No\u00EBl", "last_order_name" => "#1001", "currency" => "USD", "phone" => "+16136120707", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => null, "tax_exemptions" => [], "email_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => null, "consent_updated_at" => "2004-06-13T11:57:11-04:00"], "sms_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-04-04T17:13:27-04:00", "consent_collected_from" => "OTHER"], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => ["id" => 207119551, "customer_id" => 207119551, "first_name" => null, "last_name" => null, "company" => null, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true]]]]]
                )),
                "https://test-shop.myshopify.io/admin/api/2023-04/checkouts.json",
                "GET",
                null,
                [
                    "X-Shopify-Access-Token: this_is_a_test_token",
                ],
            ),
        ]);

        AbandonedCheckout::checkouts(
            $this->test_session,
            [],
            [],
        );
    }

    /**

     *
     * @return void
     */
    public function test_6(): void
    {
        $this->mockTransportRequests([
            new MockRequest(
                $this->buildMockHttpResponse(200, json_encode(
                  ["checkouts" => [["id" => 450789469, "token" => "2a1ace52255252df566af0faaedfbfa7", "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "email" => "bob.norman@mail.example.com", "gateway" => null, "buyer_accepts_marketing" => false, "created_at" => "2012-10-12T07:05:27-04:00", "updated_at" => "2012-10-12T07:05:27-04:00", "landing_site" => null, "note" => null, "note_attributes" => [["name" => "custom engraving", "value" => "Happy Birthday"], ["name" => "colour", "value" => "green"]], "referring_site" => null, "shipping_lines" => [["code" => "Free Shipping", "price" => "0.00", "original_shop_price" => null, "original_rate_price" => null, "original_shop_markup" => null, "source" => "shopify", "title" => "Free Shipping", "presentment_title" => null, "phone" => null, "tax_lines" => null, "custom_tax_lines" => null, "validation_context" => null, "markup" => null, "delivery_category" => null, "carrier_identifier" => null, "carrier_service_id" => null, "api_client_id" => null, "requested_fulfillment_service_id" => null, "applied_discounts" => [], "delivery_option_group_type" => null, "delivery_expectation_range" => null, "delivery_expectation_type" => null, "estimated_delivery_time_range" => null, "id" => "5da41c1738454765"]], "taxes_included" => false, "total_weight" => 400, "currency" => "USD", "completed_at" => null, "closed_at" => null, "user_id" => null, "location_id" => null, "source_identifier" => null, "source_url" => null, "device_id" => null, "phone" => null, "customer_locale" => "en", "line_items" => [["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "17243a6e53c8a58c", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Red", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 49148385, "variant_title" => "Red", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"], ["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "4b8183cc74918eca", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Pink", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008PINK", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 808950810, "variant_title" => "Pink", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"]], "name" => "#450789469", "source" => null, "abandoned_checkout_url" => "https://checkout.local/548380009/checkouts/2a1ace52255252df566af0faaedfbfa7/recover", "discount_codes" => [["code" => "TENOFF", "amount" => "39.80", "type" => "percentage"]], "tax_lines" => [["price" => "21.49", "rate" => 0.06, "title" => "State Tax", "channel_liable" => null]], "source_name" => "web", "presentment_currency" => "USD", "buyer_accepts_sms_marketing" => false, "sms_marketing_phone" => null, "total_discounts" => "39.80", "total_line_items_price" => "398.00", "total_price" => "379.69", "total_tax" => "21.49", "subtotal_price" => "358.20", "total_duties" => null, "billing_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "shipping_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "customer" => ["id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-04-04T17:13:27-04:00", "updated_at" => "2023-04-04T17:13:27-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => null, "verified_email" => true, "multipass_identifier" => null, "tax_exempt" => false, "tags" => "L\u00E9on, No\u00EBl", "last_order_name" => "#1001", "currency" => "USD", "phone" => "+16136120707", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => null, "tax_exemptions" => [], "email_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => null, "consent_updated_at" => "2004-06-13T11:57:11-04:00"], "sms_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-04-04T17:13:27-04:00", "consent_collected_from" => "OTHER"], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => ["id" => 207119551, "customer_id" => 207119551, "first_name" => null, "last_name" => null, "company" => null, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true]]]]]
                )),
                "https://test-shop.myshopify.io/admin/api/2023-04/checkouts.json?created_at_max=2013-10-12T07%3A05%3A27-02%3A00",
                "GET",
                null,
                [
                    "X-Shopify-Access-Token: this_is_a_test_token",
                ],
            ),
        ]);

        AbandonedCheckout::checkouts(
            $this->test_session,
            [],
            ["created_at_max" => "2013-10-12T07:05:27-02:00"],
        );
    }

    /**

     *
     * @return void
     */
    public function test_7(): void
    {
        $this->mockTransportRequests([
            new MockRequest(
                $this->buildMockHttpResponse(200, json_encode(
                  ["checkouts" => [["id" => 450789469, "token" => "2a1ace52255252df566af0faaedfbfa7", "cart_token" => "68778783ad298f1c80c3bafcddeea02f", "email" => "bob.norman@mail.example.com", "gateway" => null, "buyer_accepts_marketing" => false, "created_at" => "2012-10-12T07:05:27-04:00", "updated_at" => "2012-10-12T07:05:27-04:00", "landing_site" => null, "note" => null, "note_attributes" => [["name" => "custom engraving", "value" => "Happy Birthday"], ["name" => "colour", "value" => "green"]], "referring_site" => null, "shipping_lines" => [["code" => "Free Shipping", "price" => "0.00", "original_shop_price" => null, "original_rate_price" => null, "original_shop_markup" => null, "source" => "shopify", "title" => "Free Shipping", "presentment_title" => null, "phone" => null, "tax_lines" => null, "custom_tax_lines" => null, "validation_context" => null, "markup" => null, "delivery_category" => null, "carrier_identifier" => null, "carrier_service_id" => null, "api_client_id" => null, "requested_fulfillment_service_id" => null, "applied_discounts" => [], "delivery_option_group_type" => null, "delivery_expectation_range" => null, "delivery_expectation_type" => null, "estimated_delivery_time_range" => null, "id" => "5da41c1738454765"]], "taxes_included" => false, "total_weight" => 400, "currency" => "USD", "completed_at" => null, "closed_at" => null, "user_id" => null, "location_id" => null, "source_identifier" => null, "source_url" => null, "device_id" => null, "phone" => null, "customer_locale" => "en", "line_items" => [["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "17243a6e53c8a58c", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Red", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008RED", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 49148385, "variant_title" => "Red", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"], ["applied_discounts" => [], "discount_allocations" => [["id" => null, "amount" => "19.90", "description" => "TENOFF", "created_at" => null, "application_type" => "discount_code", "discount_class" => "ORDER"]], "key" => "4b8183cc74918eca", "destination_location_id" => null, "fulfillment_service" => "manual", "gift_card" => false, "grams" => 200, "origin_location_id" => null, "presentment_title" => "IPod Nano - 8GB", "presentment_variant_title" => "Pink", "product_id" => 632910392, "properties" => null, "quantity" => 1, "requires_shipping" => true, "sku" => "IPOD2008PINK", "tax_lines" => [], "taxable" => true, "title" => "IPod Nano - 8GB", "variant_id" => 808950810, "variant_title" => "Pink", "variant_price" => null, "vendor" => "Apple", "user_id" => null, "unit_price_measurement" => null, "rank" => null, "compare_at_price" => null, "line_price" => "199.00", "price" => "199.00"]], "name" => "#450789469", "source" => null, "abandoned_checkout_url" => "https://checkout.local/548380009/checkouts/2a1ace52255252df566af0faaedfbfa7/recover", "discount_codes" => [["code" => "TENOFF", "amount" => "39.80", "type" => "percentage"]], "tax_lines" => [["price" => "21.49", "rate" => 0.06, "title" => "State Tax", "channel_liable" => null]], "source_name" => "web", "presentment_currency" => "USD", "buyer_accepts_sms_marketing" => false, "sms_marketing_phone" => null, "total_discounts" => "39.80", "total_line_items_price" => "398.00", "total_price" => "379.69", "total_tax" => "21.49", "subtotal_price" => "358.20", "total_duties" => null, "billing_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "shipping_address" => ["first_name" => "Bob", "address1" => "Chestnut Street 92", "phone" => "+1(502)-459-2181", "city" => "Louisville", "zip" => "40202", "province" => "Kentucky", "country" => "United States", "last_name" => "Norman", "address2" => "", "company" => null, "latitude" => 45.41634, "longitude" => -75.6868, "name" => "Bob Norman", "country_code" => "US", "province_code" => "KY"], "customer" => ["id" => 207119551, "email" => "bob.norman@mail.example.com", "accepts_marketing" => false, "created_at" => "2023-04-04T17:13:27-04:00", "updated_at" => "2023-04-04T17:13:27-04:00", "first_name" => "Bob", "last_name" => "Norman", "orders_count" => 1, "state" => "disabled", "total_spent" => "199.65", "last_order_id" => 450789469, "note" => null, "verified_email" => true, "multipass_identifier" => null, "tax_exempt" => false, "tags" => "L\u00E9on, No\u00EBl", "last_order_name" => "#1001", "currency" => "USD", "phone" => "+16136120707", "accepts_marketing_updated_at" => "2005-06-12T11:57:11-04:00", "marketing_opt_in_level" => null, "tax_exemptions" => [], "email_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => null, "consent_updated_at" => "2004-06-13T11:57:11-04:00"], "sms_marketing_consent" => ["state" => "not_subscribed", "opt_in_level" => "single_opt_in", "consent_updated_at" => "2023-04-04T17:13:27-04:00", "consent_collected_from" => "OTHER"], "admin_graphql_api_id" => "gid://shopify/Customer/207119551", "default_address" => ["id" => 207119551, "customer_id" => 207119551, "first_name" => null, "last_name" => null, "company" => null, "address1" => "Chestnut Street 92", "address2" => "", "city" => "Louisville", "province" => "Kentucky", "country" => "United States", "zip" => "40202", "phone" => "555-625-1199", "name" => "", "province_code" => "KY", "country_code" => "US", "country_name" => "United States", "default" => true]]]]]
                )),
                "https://test-shop.myshopify.io/admin/api/2023-04/checkouts.json?status=closed",
                "GET",
                null,
                [
                    "X-Shopify-Access-Token: this_is_a_test_token",
                ],
            ),
        ]);

        AbandonedCheckout::checkouts(
            $this->test_session,
            [],
            ["status" => "closed"],
        );
    }

}
