<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class TaxRatesIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\TaxRate(array());
        $this->assertNotNull($obj);
    }
    
    public function testTaxRatesList()
    {
        $fixture = $this->loadJsonFixture('tax_rates')->list;
        $this->stub_request($fixture);

        $service = $this->client->taxRates();
        $response = call_user_func_array(array($service, 'list'), (array)$fixture->url_params);

        $body = $fixture->body->tax_rates;
    
        $records = $response->records;
        $this->assertInstanceOf('\GoCardlessPro\Core\ListResponse', $response);
        $this->assertInstanceOf('\GoCardlessPro\Resources\TaxRate', $records[0]);

        $this->assertEquals($fixture->body->meta->cursors->before, $response->before);
        $this->assertEquals($fixture->body->meta->cursors->after, $response->after);
    

    
        foreach (range(0, count($body) - 1) as $num) {
            $record = $records[$num];
            $this->assertEquals($body[$num]->end_date, $record->end_date);
            $this->assertEquals($body[$num]->id, $record->id);
            $this->assertEquals($body[$num]->jurisdiction, $record->jurisdiction);
            $this->assertEquals($body[$num]->percentage, $record->percentage);
            $this->assertEquals($body[$num]->start_date, $record->start_date);
            $this->assertEquals($body[$num]->type, $record->type);
            
        }

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testTaxRatesGet()
    {
        $fixture = $this->loadJsonFixture('tax_rates')->get;
        $this->stub_request($fixture);

        $service = $this->client->taxRates();
        $response = call_user_func_array(array($service, 'get'), (array)$fixture->url_params);

        $body = $fixture->body->tax_rates;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\TaxRate', $response);

        $this->assertEquals($body->end_date, $response->end_date);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->jurisdiction, $response->jurisdiction);
        $this->assertEquals($body->percentage, $response->percentage);
        $this->assertEquals($body->start_date, $response->start_date);
        $this->assertEquals($body->type, $response->type);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
}
