<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class BillingRequestTemplatesIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\BillingRequestTemplate(array());
        $this->assertNotNull($obj);
    }
    
    public function testBillingRequestTemplatesList()
    {
        $fixture = $this->loadJsonFixture('billing_request_templates')->list;
        $this->stub_request($fixture);

        $service = $this->client->billingRequestTemplates();
        $response = call_user_func_array(array($service, 'list'), (array)$fixture->url_params);

        $body = $fixture->body->billing_request_templates;
    
        $records = $response->records;
        $this->assertInstanceOf('\GoCardlessPro\Core\ListResponse', $response);
        $this->assertInstanceOf('\GoCardlessPro\Resources\BillingRequestTemplate', $records[0]);

        $this->assertEquals($fixture->body->meta->cursors->before, $response->before);
        $this->assertEquals($fixture->body->meta->cursors->after, $response->after);
    

    
        foreach (range(0, count($body) - 1) as $num) {
            $record = $records[$num];
            $this->assertEquals($body[$num]->authorisation_url, $record->authorisation_url);
            $this->assertEquals($body[$num]->created_at, $record->created_at);
            $this->assertEquals($body[$num]->id, $record->id);
            $this->assertEquals($body[$num]->mandate_request_currency, $record->mandate_request_currency);
            $this->assertEquals($body[$num]->mandate_request_description, $record->mandate_request_description);
            $this->assertEquals($body[$num]->mandate_request_metadata, $record->mandate_request_metadata);
            $this->assertEquals($body[$num]->mandate_request_scheme, $record->mandate_request_scheme);
            $this->assertEquals($body[$num]->mandate_request_verify, $record->mandate_request_verify);
            $this->assertEquals($body[$num]->metadata, $record->metadata);
            $this->assertEquals($body[$num]->name, $record->name);
            $this->assertEquals($body[$num]->payment_request_amount, $record->payment_request_amount);
            $this->assertEquals($body[$num]->payment_request_currency, $record->payment_request_currency);
            $this->assertEquals($body[$num]->payment_request_description, $record->payment_request_description);
            $this->assertEquals($body[$num]->payment_request_metadata, $record->payment_request_metadata);
            $this->assertEquals($body[$num]->payment_request_scheme, $record->payment_request_scheme);
            $this->assertEquals($body[$num]->redirect_uri, $record->redirect_uri);
            $this->assertEquals($body[$num]->updated_at, $record->updated_at);
            
        }

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testBillingRequestTemplatesGet()
    {
        $fixture = $this->loadJsonFixture('billing_request_templates')->get;
        $this->stub_request($fixture);

        $service = $this->client->billingRequestTemplates();
        $response = call_user_func_array(array($service, 'get'), (array)$fixture->url_params);

        $body = $fixture->body->billing_request_templates;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\BillingRequestTemplate', $response);

        $this->assertEquals($body->authorisation_url, $response->authorisation_url);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->mandate_request_currency, $response->mandate_request_currency);
        $this->assertEquals($body->mandate_request_description, $response->mandate_request_description);
        $this->assertEquals($body->mandate_request_metadata, $response->mandate_request_metadata);
        $this->assertEquals($body->mandate_request_scheme, $response->mandate_request_scheme);
        $this->assertEquals($body->mandate_request_verify, $response->mandate_request_verify);
        $this->assertEquals($body->metadata, $response->metadata);
        $this->assertEquals($body->name, $response->name);
        $this->assertEquals($body->payment_request_amount, $response->payment_request_amount);
        $this->assertEquals($body->payment_request_currency, $response->payment_request_currency);
        $this->assertEquals($body->payment_request_description, $response->payment_request_description);
        $this->assertEquals($body->payment_request_metadata, $response->payment_request_metadata);
        $this->assertEquals($body->payment_request_scheme, $response->payment_request_scheme);
        $this->assertEquals($body->redirect_uri, $response->redirect_uri);
        $this->assertEquals($body->updated_at, $response->updated_at);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testBillingRequestTemplatesCreate()
    {
        $fixture = $this->loadJsonFixture('billing_request_templates')->create;
        $this->stub_request($fixture);

        $service = $this->client->billingRequestTemplates();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);

        $body = $fixture->body->billing_request_templates;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\BillingRequestTemplate', $response);

        $this->assertEquals($body->authorisation_url, $response->authorisation_url);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->mandate_request_currency, $response->mandate_request_currency);
        $this->assertEquals($body->mandate_request_description, $response->mandate_request_description);
        $this->assertEquals($body->mandate_request_metadata, $response->mandate_request_metadata);
        $this->assertEquals($body->mandate_request_scheme, $response->mandate_request_scheme);
        $this->assertEquals($body->mandate_request_verify, $response->mandate_request_verify);
        $this->assertEquals($body->metadata, $response->metadata);
        $this->assertEquals($body->name, $response->name);
        $this->assertEquals($body->payment_request_amount, $response->payment_request_amount);
        $this->assertEquals($body->payment_request_currency, $response->payment_request_currency);
        $this->assertEquals($body->payment_request_description, $response->payment_request_description);
        $this->assertEquals($body->payment_request_metadata, $response->payment_request_metadata);
        $this->assertEquals($body->payment_request_scheme, $response->payment_request_scheme);
        $this->assertEquals($body->redirect_uri, $response->redirect_uri);
        $this->assertEquals($body->updated_at, $response->updated_at);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    public function testBillingRequestTemplatesCreateWithIdempotencyConflict()
    {
        $fixture = $this->loadJsonFixture('billing_request_templates')->create;

        $idempotencyConflictResponseFixture = $this->loadFixture('idempotent_creation_conflict_invalid_state_error');

        // The POST request responds with a 409 to our original POST, due to an idempotency conflict
        $this->mock->append(new \GuzzleHttp\Psr7\Response(409, [], $idempotencyConflictResponseFixture));

        // The client makes a second request to fetch the resource that was already
        // created using our idempotency key. It responds with the created resource,
        // which looks just like the response for a successful POST request.
        $this->mock->append(new \GuzzleHttp\Psr7\Response(200, [], json_encode($fixture->body)));

        $service = $this->client->billingRequestTemplates();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);
        $body = $fixture->body->billing_request_templates;

        $this->assertInstanceOf('\GoCardlessPro\Resources\BillingRequestTemplate', $response);

        $this->assertEquals($body->authorisation_url, $response->authorisation_url);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->mandate_request_currency, $response->mandate_request_currency);
        $this->assertEquals($body->mandate_request_description, $response->mandate_request_description);
        $this->assertEquals($body->mandate_request_metadata, $response->mandate_request_metadata);
        $this->assertEquals($body->mandate_request_scheme, $response->mandate_request_scheme);
        $this->assertEquals($body->mandate_request_verify, $response->mandate_request_verify);
        $this->assertEquals($body->metadata, $response->metadata);
        $this->assertEquals($body->name, $response->name);
        $this->assertEquals($body->payment_request_amount, $response->payment_request_amount);
        $this->assertEquals($body->payment_request_currency, $response->payment_request_currency);
        $this->assertEquals($body->payment_request_description, $response->payment_request_description);
        $this->assertEquals($body->payment_request_metadata, $response->payment_request_metadata);
        $this->assertEquals($body->payment_request_scheme, $response->payment_request_scheme);
        $this->assertEquals($body->redirect_uri, $response->redirect_uri);
        $this->assertEquals($body->updated_at, $response->updated_at);
        

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $conflictRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $conflictRequest->getUri()->getPath());
        $getRequest = $this->history[1]['request'];
        $this->assertEquals($getRequest->getUri()->getPath(), '/billing_request_templates/ID123');
    }
    
    public function testBillingRequestTemplatesUpdate()
    {
        $fixture = $this->loadJsonFixture('billing_request_templates')->update;
        $this->stub_request($fixture);

        $service = $this->client->billingRequestTemplates();
        $response = call_user_func_array(array($service, 'update'), (array)$fixture->url_params);

        $body = $fixture->body->billing_request_templates;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\BillingRequestTemplate', $response);

        $this->assertEquals($body->authorisation_url, $response->authorisation_url);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->mandate_request_currency, $response->mandate_request_currency);
        $this->assertEquals($body->mandate_request_description, $response->mandate_request_description);
        $this->assertEquals($body->mandate_request_metadata, $response->mandate_request_metadata);
        $this->assertEquals($body->mandate_request_scheme, $response->mandate_request_scheme);
        $this->assertEquals($body->mandate_request_verify, $response->mandate_request_verify);
        $this->assertEquals($body->metadata, $response->metadata);
        $this->assertEquals($body->name, $response->name);
        $this->assertEquals($body->payment_request_amount, $response->payment_request_amount);
        $this->assertEquals($body->payment_request_currency, $response->payment_request_currency);
        $this->assertEquals($body->payment_request_description, $response->payment_request_description);
        $this->assertEquals($body->payment_request_metadata, $response->payment_request_metadata);
        $this->assertEquals($body->payment_request_scheme, $response->payment_request_scheme);
        $this->assertEquals($body->redirect_uri, $response->redirect_uri);
        $this->assertEquals($body->updated_at, $response->updated_at);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
}
